﻿$(function () {
    debugger;
    //Define the Global Variables across functions.
    var bingMapsKey = 'Av5A7yAWKLOF6lCCjOLl0I4tUh5b6ZP9c25PHmLrQF9zJGpW7lnYPAvm1Odo52VV';
    var dataLayer, map, infobox, searchManager, orgUrl, webAPIUrl, loadProviders, options, fetchxml, viewId, userQueryId;
    var requestType = "ppms_providerservices";
    var locs = [];
    var pins = [];
    var listItems = [];
    var orgUrl = window.parent.Xrm.Page.context.getClientUrl();
    var webAPIUrl = orgUrl + "/api/data/v8.2/";

    //We will load the map and other fucntions once the HTML page has finished loading. 
    document.onreadystatechange = function () {
        if (document.readyState == "complete") {
            getViewId();
        }
    }

    function getViewId() {
        //Get the any query string parameters and load them
        //into the vals array
        var vals = new Array();
        if (location.search != "") {
            vals = location.search.substr(1);
            //Get the view Id here.
            viewId = vals.replace('Data=', '');
            //Run the Query, get all the Provider Service ID's. 
            retrieveProviderServiceIds();
            //Rebuild the Fetchxml with required fields. 
            //Save new fetchxml to new view. 
            //Re-run the query with referenced new view id. 


        } else {
            alert("Saved View Not Found.");
        }
    }

    function retrieveProviderServiceIds() {

        //Generate a Request URL with options to Query CRM Web API data. 
        var request = new String();
        request += webAPIUrl + requestType + "?savedQuery=" + viewId;

        $.ajax({
            type: "GET",
            contentType: "application/json; charset=utf-8",
            datatype: "json",
            url: request,
            beforeSend: function (XMLHttpRequest) {
                //Specifying this header ensures that the results will be returned as JSON.             
                XMLHttpRequest.setRequestHeader("Accept", "application/json");
            },
            success: function (data, textStatus, xhr) {
                var providerServices = data.value;
                if (providerServices.length > 0) { rebuildFetchXml(providerServices); }
                else { showErrorMsg('No Provider Services found matching the Search Criteria'); }
            },
            error: function (e) {
                //If we didn't find results in a Saved View, try User Query Table. 
                if (e.status == "404") {
                    request = new String();
                    request += webAPIUrl + requestType + "?userQuery=" + viewId;
                    $.ajax({
                        type: "GET",
                        contentType: "application/json; charset=utf-8",
                        datatype: "json",
                        url: request,
                        beforeSend: function (XMLHttpRequest) {
                            //Specifying this header ensures that the results will be returned as JSON.             
                            XMLHttpRequest.setRequestHeader("Accept", "application/json");
                        },
                        success: function (data, textStatus, xhr) {
                            var providerServices = data.value;
                            if (providerServices.length > 0) { rebuildFetchXml(providerServices); }
                            else { showErrorMsg('No Provider Services found matching the Search Criteria'); }
                        },
                        error: function (e) {
                            showErrorMsg(e.statusText);
                        }
                    });
                } else {
                    showErrorMsg(e.statusText);
                }
            }
        });
    }

    function rebuildFetchXml(providerServices) {

        var fetchXml = new String();
        fetchXml =
            '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="true">' +
            '<entity name="ppms_providerservice">' +
            '<attribute name="ppms_name"/>' +
            '<attribute name="ppms_caresiteaddress" />' +
            '<attribute name="ppms_caresitecity" />' +
            '<attribute name="ppms_caresitestateprovince" />' +
            '<attribute name="ppms_caresitezipcode" />' +
            '<attribute name="ppms_caresiteaddresslatitude" />' +
            '<attribute name="ppms_caresiteaddresslongitude" />' +
            '<attribute name="ppms_specialtynametext" />' +
            '<attribute name="ppms_providername" />' +
            '<attribute name="ppms_providerid" />' +
            '<attribute name="ppms_workhours" />' +
            '<attribute name="ppms_providerserviceid" />' +
            '<order attribute="ppms_name" descending="false" />' +
            '<filter type="and">' +
            '<condition attribute="ppms_providerserviceid" operator="in">';
        for (var i = 0; i < providerServices.length; i++) {
            //Format the ID to remove braces
            var ProviderServiceId = providerServices[i].ppms_providerserviceid.toString();
            //ProviderServiceId = ProviderServiceId.replace(/[{}]/g, "");
            fetchXml +=
                '<value uiname="" uitype="ppms_providerservice">{' + ProviderServiceId + '}</value>';
        }
        //Close out the FetchXml
        fetchXml += '</condition ></filter ></entity> </fetch >';

        var userQuery = JSON.stringify({
            "name": "User Defined Provider Query",
            "description": "User Defined Provider Query from Options Selected.",
            "returnedtypecode": "ppms_providerservice",
            "fetchxml": fetchXml,
            "querytype": 0
        });
        $.ajax({
            type: "POST",
            contentType: "application/json; charset=utf-8",
            datatype: "json",
            url: webAPIUrl + "userqueries",
            data: userQuery,
            beforeSend: function (XMLHttpRequest) {
                //Specifying this header ensures that the results will be returned as JSON.             
                XMLHttpRequest.setRequestHeader("Accept", "application/json");
            },
            success: function (data, textStatus, xhr) {
                //var userQueryIdUrl = xhr.getResponseHeader("Odata-EntityId");
                var parseQuery = /\(([^)]+)\)/;
                var queryMatches = parseQuery.exec(xhr.getResponseHeader("Odata-EntityId"));
                userQueryId = queryMatches[1];
                //Start Map
                startMap();
            },
            error: function (e) {
                showErrorMsg('Unable to generate Query');
            }
        });
    }


    function startMap() {

        // Load the map.
        map = new Microsoft.Maps.Map(document.getElementById('myMap'),
            {
                credentials: bingMapsKey,
                //center: new Microsoft.Maps.Location(38.890369, -77.031960),
                mapTypeId: Microsoft.Maps.MapTypeId.road,
                zoom: 12
            });

        Microsoft.Maps.loadModule('Microsoft.Maps.HeatMap');
        Microsoft.Maps.loadModule('Microsoft.Maps.Clustering');

        // A setting for specifying the distance units displayed. Possible values are 'km' and 'mi'.
        var distanceUnits = 'mi';

        // Create a global infobox control.
        infobox = new Microsoft.Maps.Infobox(new Microsoft.Maps.Location(0, 0),
            {
                visible: false,
                offset: new Microsoft.Maps.Point(0, 20),
                height: 230,
                width: 230
            });
        infobox.setOptions({ showPointer: true, showCloseButton: true, maxHeight: 500, maxWidth: 500 });
        infobox.setMap(map);

        // Create a session key from the map to use with data source service requests.
        var sessionKey;
        map.getCredentials(function (c) {
            sessionKey = c;
        });

        // Resize the height of the results panel based on the available space.
        $(window).resize(function () {
            $('.mapPanel').height($(window).height() - 100);
        });
        $(window).resize();


        // A simple function for displaying error messages in the app.
        function showErrorMsg(msg) {
            $('.resultsPanel').html('<span class="errorMsg">' + msg + '</span>');
        }

        //Add An on Change Event for the Map Selection box. 
        $('#mapSelection').change(function () {

            clearMap();
            var mapType = $("#mapSelection option:selected").val();

            switch (mapType) {
                case "Map":
                    var pinlayer = new Microsoft.Maps.Layer();
                    pinlayer.add(pins);
                    map.layers.insert(pinlayer);
                    break;
                case "HeatMap":
                    var heatMapLayer = new Microsoft.Maps.HeatMapLayer(locs);
                    map.layers.insert(heatMapLayer);
                    break;
                case "ClusterMap":
                    var clusterLayer = new Microsoft.Maps.ClusterLayer(pins, { gridSize: 100 });
                    map.layers.insert(clusterLayer);
                    break;
                default:

                    break;
            }
        });

        // A simple function for clearing the map and results panel.
        function clearMap() {
            map.layers.clear();
            infobox.setOptions({ visible: false });
        }

        findProviders();

        function findProviders() {

            //Generate a Request URL with options to Query CRM Web API data. 
            var request = new String();
            request += webAPIUrl + requestType + "?userQuery=" + userQueryId;

            $.ajax({
                type: "GET",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                url: request,
                beforeSend: function (XMLHttpRequest) {
                    //Specifying this header ensures that the results will be returned as JSON.             
                    XMLHttpRequest.setRequestHeader("Accept", "application/json");
                },
                success: function (data, textStatus, xhr) {
                    var providerServices = data.value;
                    if (providerServices.length > 0) {
                        AddProviderServicesToMap(providerServices);
                        cleanUpUserQuery();
                    }
                    else { showErrorMsg('No Providers found matching the Search Criteria'); }
                },
                error: function (e) {
                    showErrorMsg(e.statusText);
                }
            });

        }

        function cleanUpUserQuery() {

            //Delete the userquery that was created. 
            $.ajax({
                type: "DELETE",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                url: webAPIUrl + "userqueries(" + userQueryId + ")",
                beforeSend: function (XMLHttpRequest) {
                    //Specifying this header ensures that the results will be returned as JSON.             
                    XMLHttpRequest.setRequestHeader("Accept", "application/json");
                },
                success: function (data, textStatus, xhr) {
                },
                error: function (e) {
                    var error = e;
                }
            });
        }

        function AddProviderServicesToMap(providers) {

            listItems.push('<table class="listItem table table table-hover"><thead><tr><th>#</th><th>Provider</th><th>Directions</th></tr></thead><tbody>');
            //Loop through the Providers and add them to the map. 
            for (var p = 0; p < providers.length; p++) {
                //Define the Provider's Location for the map. 
                var loc = new Microsoft.Maps
                    .Location(providers[p].ppms_caresiteaddresslatitude, providers[p].ppms_caresiteaddresslongitude);
                // Add the location coordinate to the array of locations
                locs.push(loc);
                // Create pushpin
                var pin = new Microsoft.Maps.Pushpin(loc,
                    {
                        icon: null,
                    }
                );
                // Store the location result info as a property of the pushpin so we can use it later.
                pin.Metadata = providers[p];
                // Add a click event to the pushpin to display an infobox.
                Microsoft.Maps.Events.addHandler(pin,
                    'mouseover',
                    function (e) {
                        displayInfobox(e.target);
                    });
                // Add the pushpin to the map.
                pins.push(pin);

                listItems.push('<tr>');
                listItems.push('<th scope="row">' + locs.length + '</th>')

                listItems
                    .push('<td><a class="title" href="javascript:void(0);" rel="',
                    providers[p].ppms_providerserviceid, '">',
                    providers[p].ppms_providername,
                    '</a><br/>' + '<a id="providerAddressText" href="#">', providers[p].ppms_caresiteaddress, '<br>', providers[p].ppms_caresitecity, ",", providers[p].ppms_caresitestateprovince, '<br>', providers[p].ppms_caresitezipcode, '</a>'
                    );
                listItems.push(
                    '<br/>',
                    '<a id="providerProfile" alt="Profile for ', providers[p].ppms_providername, '" title="Profile for ', providers[p].ppms_providername, '" class="viewprofile" href="javascript:void(0);" rel="',
                    providers[p]._ppms_providerid_value,
                    '">',
                    "View Profile",
                    '</a></td>');
                listItems
                    .push('<td><a id="providerDirections" alt="Directions for ', providers[p].ppms_providername, '" title="Directions for ', providers[p].ppms_providername, '" target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                    null,
                    '~pos.',
                    pin.Metadata.ppms_caresiteaddresslatitude,
                    '_',
                    pin.Metadata.ppms_caresiteaddresslongitude,
                    '_',
                    encodeURIComponent(pin.Metadata.ppms_providername),
                    '">Directions</a></td>');
            }

            listItems.push('</tr>');
            listItems.push('</tbody>');
            listItems.push('</table>');

            var pinlayer = new Microsoft.Maps.Layer();
            pinlayer.add(pins);
            map.layers.insert(pinlayer);

            // Use the array of locations from the results to set the map view to show all locations.
            if (locs.length > 1) {
                map
                    .setView({
                        bounds: Microsoft.Maps.LocationRect.fromLocations(locs),
                        padding: 80
                    });
            } else {
                map.setView({ center: locs[0], zoom: 15 });
            }

            // Add the list items to the results panel.
            $('.resultsPanel').html(listItems.join(''));

            // Add a click event to the title of each list item.
            $('.title').click(function () {
                // Get the ID of the selected location
                var id = $(this).attr('rel');
                //Loop through all the pins in the data layer and find the pushpin for the location.
                var pin;
                for (var i = 0; i < pins.length; i++) {
                    pin = pins[i];
                    if (pin.Metadata.ppms_providerserviceid != id) {
                        pin = null;
                    } else {
                        break;
                    }
                }
                // If a pin is found with a matching ID, then center the map on it and show it's infobox.
                if (pin) {
                    // Offset the centering to account for the infobox.
                    map.setView({
                        center: pin.getLocation(),
                        centerOffset: new Microsoft.Maps.Point(-70, 150),
                        zoom: 17
                    });
                    displayInfobox(pin);
                }
            });
            $('.viewprofile').click(function () {
                // Get the ID of the selected Provider
                var id = $(this).attr('rel');
                var windowOptions = {
                    openInNewWindow: true
                };
                Xrm.Utility.openEntityForm("account", id, null, windowOptions)
            });
        }

        // Takes a pushpin and generates the content for the infobox from the Metadata and displays the infobox.
        function displayInfobox(pin) {


            infobox.setLocation(pin.getLocation());

            var desc = ['<table>'];

            //Title/Provider Name
            desc.push('<tr><td><a id="infoBoxTitleText" href="#"><b>', pin.Metadata.ppms_providername, '</b></a></td></tr>');

            //Address
            desc.push('<tr><td><a id="infoBoxAddressText" href="#">', pin.Metadata.ppms_caresiteaddress, '<br/>', pin.Metadata.ppms_caresitecity, ",", pin.Metadata.ppms_caresitestateprovince, ' ', pin.Metadata.ppms_caresitezipcode, '</a></td></tr>');

            //Hours
            desc.push('<tr><td><a id="infoBoxHoursText" href="#"><b>Hours:</b>', pin.Metadata.ppms_workhours, '</a></td></tr>');

            //Specialty
            desc.push('<tr><td><a id="infoBoxSpecialtyText" href="#"><b>Specialty:</b>', pin.Metadata.ppms_specialtynametext, '</a></td></tr>');

            //View Profile
            desc.push('<tr><td><a alt="Profile for ', pin.Metadata.ppms_providername, '" title="Profile for ', pin.Metadata.ppms_providername, '" id="providerProfile" class="viewprofile" href="javascript:void(0);" rel="',
                pin.Metadata._ppms_providerid_value, '">', "Profile ", '');
            //Directions
            desc.push('<a alt="Directions for ', pin.Metadata.ppms_providername, '" title="Directions for ', pin.Metadata.ppms_providername, '" target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                null, '~pos.', pin.Metadata.ppms_caresiteaddresslatitude, '_', pin.Metadata.ppms_caresiteaddresslongitude, '_', encodeURIComponent(pin.Metadata.ppms_providername), '">Directions  </a>');
            //Close Infobox
            desc.push('<a alt="Close Infobox" title="Close Infobox" class="closeInfobox" href="javascript:void(0);" rel="', pin, '">', " Close", '</a></td></tr>');
            //Close Table
            desc.push('</table>');

            //infobox.setOptions({ visible: true, title: pin.Metadata.ppms_name, description: desc.join('') });
            infobox.setOptions({ visible: true, description: desc.join('') });

            $('.closeInfobox').click(function () {
                infobox.setOptions({ visible: false });
            });

            $('.viewprofile').click(function () {
                // Get the ID of the selected Provider
                var id = $(this).attr('rel');
                var windowOptions = {
                    openInNewWindow: true
                };
                Xrm.Utility.openEntityForm("account", id, null, windowOptions)
            });

        }
    }
});